<?php

if(!empty($this->contact->locations))
	{
	// Close the container for full width maps
	?>
    </div>
    <div class="container">
    <?php
	foreach($this->contact->locations as $location)
		{
	?>
    <div class="col-xs-12 col-md-6" itemscope itemtype="http://schema.org/LocalBusiness">
    	
        <div class="col-xs-12">
            <h2 class="col-xs-12"><span itemprop="name"><?php echo $location['officename']; ?></span></h2>
            <?php
            if($location['officephone']!='')
                {
            ?>
            <div class="col-xs-12 lh-40">
                <i class="ion-android-call txt-lg col-xs-2 alg-cr pad-r-md"></i>
                <a href="tel:<?php echo $location['officephone']; ?>" class="col-xs-10 txt-mid-grey txt-white-hover" itemprop="telephone"><span itemprop="telephone"><?php echo $location['officephone']; ?></span></a>
            </div>
            <?php
                }
            
            if($location['officemobile']!='')
                {
            ?>
            <div class="col-xs-12 lh-40">
                <i class="ion-android-phone-portrait txt-lg col-xs-2 alg-cr pad-r-md"></i> 
                <a href="tel:<?php echo $location['officemobile']; ?>" class="col-xs-10 txt-mid-grey txt-white-hover"><?php echo $location['officemobile']; ?></a>
            </div>
            <?php
                }
            
            if($location['officeaddress']!='')
                {
				$ofid = str_replace(' ', '_', strtolower($location['officename']));
            ?>
            <div class="col-xs-12 lh-40">
                <i class="ion-android-pin txt-lg col-xs-2 alg-cr pad-r-md"></i> 
                <span class="col-xs-10 txt-mid-grey txt-white-hover" itemprop="address" itemscope itemtype="http://schema.org/PostalAddress">
					<span class="col-xs-12 pad-none" itemprop="streetAddress"><?php echo $location['officeaddressstreet']; ?></span>
                    <span class="pull-left pad-none" itemprop="addressLocality"><?php echo $location['officeaddresssuburb']; ?></span><span class="pull-left pad-r">,</span><span class="pull-left pad-none pad-r" itemprop="addressRegion"><?php echo $location['officeaddressstate']; ?></span> <span class="pull-left pad-none" itemprop="postalCode"><?php echo $location['officeaddresspostcode']; ?></span>
                </span>
            </div>
            <?php
                }
            
            ?>
        </div>
    </div>
    <?php	
		}
	// Open the container to ensure page structure
	?>
    </div>
	<div id="map" style="height:500px;width:100%;"></div>
<script>

var markers = [];
var aust = {lat: -32.891, lng: 134.871};

function initMap() {
	
	var currentMark;
	
	var map = new google.maps.Map(document.getElementById('map'), {
	zoom: 5,
	center: aust,
	height:500,
	width:'100%',
	mapTypeControlOptions: {
         mapTypeIds: [google.maps.MapTypeId.ROADMAP, 'grayscale']
    }
	});
	
	var sty = [
	{
		featureType: "administrative",
		elementType: "labels",
		stylers: [
			{ visibility: "off" }
		]
	},
	{
		featureType: "poi",
		elementType: "labels",
		stylers: [
			{ visibility: "off" }
		]
	},
	{
		featureType: "water",
		elementType: "labels",
		stylers: [
			{ visibility: "off" }
		]
	},
	{
		featureType: "road",
		elementType: "labels",
		stylers: [
			{ visibility: "on" }
		]
	},	
	{
		stylers: [
			{ saturation: -100 }
		]
	}
	];
	
	
	var mapType = new google.maps.StyledMapType(sty, { name:"SASS" });    
	
	map.mapTypes.set('grayscale', mapType);
	map.setMapTypeId('grayscale');
	
	<?php
	$locs = array_reverse($this->contact->locations);
	
	foreach($locs as $location)
		{
		$latlng = explode(',', $location['officelatlng']);
	?>
	var lbl = '<span class="alg-cr"><img src="http://<?php echo $this->page->site['siteurl']; ?>/_media/images/sass-mgmt-white.png" class="info-logo pad-none" /><br/><?php echo $location['officename']; ?><br/><b>P</b> <?php echo $location['officephone']; ?><br/><b>A</b> <?php echo $location['officeaddress']; ?></span>';
	
	var infoWindow<?php echo $location['ofid']; ?> = new google.maps.InfoWindow({
		content: lbl
	});
	
	var marker<?php echo $location['ofid']; ?> = new google.maps.Marker({
		map: map,
		position: {lat:<?php echo $latlng[0]; ?>,lng:<?php echo $latlng[1]; ?>},
		icon: 'http://sassmanagement.com/_media/images/map_marker_dark.png',
		title: '<?php echo $location['officename']; ?>'
	
	}).addListener('click', function() {
		map.setZoom(16);
		map.setCenter({lat:<?php echo $latlng[0]; ?>,lng:<?php echo $latlng[1]; ?>});
		currentMark = this;
		currentMark.setVisible(false);
		infoWindow<?php echo $location['ofid']; ?>.open(map, this);
		
	});
	
	markers.push(marker<?php echo $location['ofid']; ?>);
	
	google.maps.event.addListener(infoWindow<?php echo $location['ofid']; ?>,'closeclick',function(){
	   currentMark.setVisible(true);
	});
	<?php
		}
	?>

	var centerControlDiv = document.createElement('div');
	var centerControl = new CenterControl(centerControlDiv, map, infoWindow<?php echo $location['ofid']; ?>, currentMark);
	
	centerControlDiv.index = 1;
	map.controls[google.maps.ControlPosition.TOP_CENTER].push(centerControlDiv);

	
	}



function CenterControl(controlDiv, map, info, currentMark) {

  // Set CSS for the control border.
  var controlUI = document.createElement('div');
  controlUI.style.backgroundColor = '#fff';
  controlUI.style.border = '2px solid #fff';
  controlUI.style.borderRadius = '3px';
  controlUI.style.boxShadow = '0 2px 6px rgba(0,0,0,.3)';
  controlUI.style.cursor = 'pointer';
  controlUI.style.marginBottom = '22px';
  controlUI.style.textAlign = 'center';
  controlUI.title = 'Click to recenter the map';
  controlDiv.appendChild(controlUI);

  // Set CSS for the control interior.
  var controlText = document.createElement('div');
  controlText.style.color = 'rgb(25,25,25)';
  controlText.style.fontFamily = '"Century Gothic",Arial,Helvetica,sans-serif';
  controlText.style.fontSize = '12px';
  controlText.style.lineHeight = '38px';
  controlText.style.paddingLeft = '15px';
  controlText.style.paddingRight = '15px';
  controlText.innerHTML = 'View All SASS MGMT Locations';
  controlUI.appendChild(controlText);

  // Setup the click event listeners: simply set the map to Chicago.
  controlUI.addEventListener('click', function() {
    map.setZoom(5);
	map.setCenter(aust);
  });

}


</script>
<script async defer src="https://maps.googleapis.com/maps/api/js?key=AIzaSyBJT9krcQ32bLwk9G1d86KALB3mUJBjyPo&callback=initMap"></script>
    <div class="container pad-none">  
    <?php
	}
?>



