<div id="tabs" class="tabs col-xs-12 pad-none bg-off-white lh-50">
	<div class="tab txt-dk-grey active" tab-id="first">Media Manager</div>
    <div class="tab txt-dk-grey" tab-id="help">Help</div>
</div>
<form id="form" my-process="media" my-action="crop" enctype="multipart/form-data">
<input type="hidden" id="xc" />
<input type="hidden" id="yc" />
<input type="hidden" id="wc" />
<input type="hidden" id="hc" />
<input type="hidden" id="editfile" name="editfile" value="content" />
<input type="hidden" id="directory" name="directory" value="content" />
<input type="hidden" id="minwidth" value="0" />
<input type="hidden" id="minheight" value="0" />
<input type="hidden" id="ratio" value="0" />
<div class="form">
	<div class="group" id="first">
    	<div class="col-xs-12 txt-drk-grey txt-md pad-t-md">
        	Media Manager
        </div>    	
    	<div class="col-xs-12">
        	<p>Welcome to the Media Manager.</p>
            <p>You can view, upload, download, crop and resize files from here.</p>
            <p>For more info on certain features, click on the Help tab at the top.</p>
        </div>
        <div class="col-xs-12" id="uploader">
        	<label for="sourcefile" class="lbl">Upload File:</label>
            <?php
			$this->admin->fields->filedrop('fileupload', 'sourcefile');
            ?>	
        </div>  
        <div class="col-xs-12" id="workpad">
        	
        </div>        
        <div class="col-xs-12">
        	<div id="media">
                <div id="media-tools">
                    <div class="media-tool-sizer media-sizer-active" my-size="sm"><i class="fa fa-th fa-icn-lrg fa-icn-lrg-60"></i>Small Display</div>
                    <div class="media-tool-sizer" my-size="md"><i class="fa fa-th-large fa-icn-lrg fa-icn-lrg-60"></i>Medium Display</div>
                    <div class="media-tool-sizer" my-size="lg"><i class="fa fa-stop fa-icn-lrg fa-icn-lrg-60"></i>Large Display</div>
                </div>
                <div id="media-nav-bg"></div>
                <div id="media-nav">
                    <?php
					foreach($this->media->paths as $path)
						{
						$path = substr($path, 0, -1);
						$act = $path=='content' ? ' media-nav-active' : '';
					?>
                    <div class="media-nav<?php echo $act; ?>" my-folder="<?php echo $path; ?>">
                    	<?php echo ucwords($path); ?>	
                    </div>
                    <?php	
						}
					?>
                </div>
            	<div id="media-files">
                	<?php
					foreach($this->media->files as $path => $files)
						{
						$path = substr($path, 0, -1);
						
						$act = $path=='content' ? ' media-files-active' : '';
					?>
                    <div class="media-files<?php echo $act; ?>" id="media-files-<?php echo $path; ?>">
                    <?php
						
						$imgs = array('.jpg', '.png', 'jpeg', '.gif');
												
						foreach($files as $file)
							{
							$le = substr($file, -4);
							
							if(in_array($le, $imgs))
								{
								$t = 'media-file-image';
								$d = getimagesize('./_media/'.$path.'/'.$file);
								$i = '<span class="media-file-info"><span class="media-file-lbl">Dimensions:</span> '.$d[0].'w x '.$d[1].'h</span>
										<span class="media-file-info"><span class="media-file-lbl">Type:</span> '.$d['mime'].'</span>
										<span class="media-file-tools" media-path="'.$path.'" media-img="'.$file.'">
											<span class="media-file-tool" media-action="crop"><i class="fa fa-crop fa-icn-sml fa-icn-sml-30"></i>Crop</span>
											<span class="media-file-tool" media-action="resize"><i class="fa fa-expand fa-icn-sml fa-icn-sml-30"></i>Resize</span>
											<span class="media-file-tool" media-action="delete"><i class="fa fa-trash fa-icn-sml fa-icn-sml-30"></i>Delete</span>
										</span>';
								$f = '<img src="/_media/'.$path.'/'.$file.'" alt="'.$file.'" title="'.$file.'" class="media-img" />';	
								}
							elseif(substr($file, -4)=='.pdf')
								{
								$t = 'media-file-pdf';
								$i = '	<span class="media-file-tools" media-path="'.$path.'" media-img="'.$file.'">
											<span class="media-file-tool" media-action="delete"><i class="fa fa-trash fa-icn-sml fa-icn-sml-30"></i>Delete</span>
										</span>';
								$f = '<a href="/_media/'.$path.'/'.$file.'" class="media-file-link" target="_blank"><i class="fa fa-pdf-o fa-icn-lrg fa-icn-lrg-60"></i>View PDF '.$file.'</a>';	
								}
							else
								{
								$t = 'media-file-dl';
								$i = '	<span class="media-file-tools" media-path="'.$path.'" media-img="'.$file.'">
											<span class="media-file-tool" media-action="delete"><i class="fa fa-trash fa-icn-sml fa-icn-sml-30"></i>Delete</span>
										</span>';
								$f = '<a href="/_media/'.$path.'/'.$file.'" class="media-file-link"><i class="fa fa-download fa-icn-lrg fa-icn-lrg-60"></i>Download '.$file.'</a>';	
								}
						?>
                        <div class="media-file media-file-sm <?php echo $t; ?>">
                        	<?php echo $f.$i; ?>
                        </div>
                        <?php								
							}
					?>
                    </div>
                    <?php	
						}
					?>    
                </div>
            </div>
        </div>
    </div>
    <div class="group group-hdn" id="help">
    	<div class="col-xs-12 txt-drk-grey txt-md pad-t-md">
        	Help
        </div>
        <div class="col-xs-12">
        	<p>Welcome to the SMEWS Media Manager Help.</p>
            <p>You can find some basic info here on different tasks you can complete using the media manager.</p>
            <p>Most areas of the site feature their own uploading tool which will have certain features applied directly to those uploads.</p>
            <p>This section is designed to give you access to all of the tools and features.</p>
            <p>Certain library and settings must be enabled with your hosting service for these features to work.</p>
            <p>It is also possible for the developer to change the image library that is used for image manipulation.</p>
        </div>
        <div class="col-xs-12 txt-drk-grey txt-md pad-t-md">
        	File Browsing
        </div>
        <div class="col-xs-12">
        	<p>You can use the media manager to browse through the files in the "_media" directory of the website.</p>
            <p>For example, if you are managing a web page article and upload an image, the picture directory will be set to the "content" folder and the file will be renamed to be the same as the CURL name for the article.</p>
            <p>Depending on your website configuration and what you asked for, the developer may have also configured these images to be resized.</p>
        </div>
        <div class="col-xs-12 txt-drk-grey txt-md pad-t-md">
        	File Uploading
        </div>
        <div class="col-xs-12">
        	<p>To upload a file, navigate to the folder in the media navgiator that you want to upload the file to.</p>
            <p>You can then click on the "Select File" option to browse for a file, or you can drag and drop a file into the area provided.</p>
        </div>
        <div class="col-xs-12 txt-drk-grey txt-md pad-t-md">
        	File Deleting
        </div>
        <div class="col-xs-12">
        	<p>To delete a file simply find the file in your file navigator. The file should have a small icon set which allows you to delete the item.</p>
            <p>You will be prompted with a dialog confirming that you want to remove the file.</p>
            <p>You should be cautious about removing files though because if they are linked to a content item or are used on the site for a button or icon, they will no longer work.</p>
        </div>
        <div class="col-xs-12 txt-drk-grey txt-md pad-t-md">
        	Image Resizing
        </div>
        <div class="col-xs-12">
        	<p>You can resize images using the image resizing tool. Some sections may automatically resize during upload but this depends on your configuration.</p>
            <p>To resize an image simply locate the file in the file navigator. Then click on the resize tool. This will...</p>
        </div>
        <div class="col-xs-12 txt-drk-grey txt-md pad-t-md">
        	Image Cropping
        </div>
        <div class="col-xs-12">
        	<p>You can crop images and select part of a part as the new image.</p>
            <p>To crop an image, locate the file in the file navigator and click on the "Crop Image" tool.</p>
            <p>This will place the image into the cropping manager at the top of the page.</p>
            <p>You can then drag and select a region that you want to crop and use for the image.</p>
            <p>If your developer has enabled the ratios, then you may be able to switch between a few selected ratios to ensure you image matches the area you are using it for.</p>
            <p class="txt-red">N.B. If you are trying to crop an image that is larger than your screen, this may cause issues. It is highly recommended you resize images larger than your screen before cropping.</p>
        </div>
        
	</div>
</div>
</form>