

	

$('body').on('focus', '.line-item-name', function(event){
	
	$('#line-item-finder').attr('id', '');
	$(this).attr('id', 'line-item-finder');
	
	$('#line-item-finder').autocomplete({
		minLength: 2,
		source: function(request, response) {
			$.ajax({
				url: '/ajax/box/finder',
				dataType: "json",
				data: {term : request.term},
				success: function(data) {response(data);}
			});
		},
		select: function( event, ui ) {
				event.preventDefault();
				$(this).parent('.row').children('.line-item-code').val(ui.item.code);
				$(this).val(ui.item.name);
				$('#line-item-finder').autocomplete('destroy');
				return false;
		}});
	
	});



$('body').on('click', '.add-line-item', function(){
	
	var row = $(this).parent('.line-item');
	var cln = row.clone(true, true);
	cln.hide();
	cln.children('.input').val(null);
	row.after(cln);
	cln.slideDown(250);
	calculateTotal();
	});

$('body').on('click', '.del-line-item', function(){
	
	var row = $(this).parent('.line-item');
	row.children('.input').val(null);
	
	if($('.line-item').length > 1)
		{
		row.slideUp(250,0, function(){row.remove();});	
		}
	calculateTotal();
	});


$('body').on('blur', '.line-item-name, .line-item-price', function(){
	calculateTotal();
	});


function calculateTotal()
	{
	var ttl = 0;
	var rowprc = '';
	
	$('.line-item-price').each(function(i, e){
		rowprc = $(this).val();	
		ttl += rowprc!='0' &&  rowprc!='' ? parseFloat(rowprc) : 0;
    	});
	
	ttl = ttl.toFixed(2);
	
	$('#totalvalue').val(ttl);
	}




// Content Editor
tinyMCELoader('packagingdescription');

function formPostUpdate(result)
	{
	if(result.success)
		{
		$('#file-upload, #file-dropzone').removeClass('row-hdn');
		}
	}

mediaUpload('sourcefile', 'box');

function mediaUploadPost(data)
	{
	if(data.result.success)
		{
		$('#image-preview, #image-preview-uploader').attr('src', data.result.filepath);
		$('.delete-photo').attr('my-file', data.result.filename);
		$('.photo').removeClass('row-hdn');	
		$('#packagingimage').attr('value', data.result.filepath);
		displayResponse(data.result.success, 'success');
		}
	else if(data.result.error)
		{
		displayResponse(data.result.error, 'error');
		}
	else
		{
		displayResponse('An unknown error occurred.', 'error');
		}
	}

removeMedia('box', '.delete-photo', 'Are you sure you want to remove this packaging item photo? This cannot be undone', 'Confirm Packaging Image Delete', '.photo');