/**
 *
 *	Classpicker - Colours
 *
 */

$('body').on('click', '.clspckr-opt', function(){
	
	// Toggle Classes on Field Selectos
	$('.clspckr-opt').not($(this)).removeClass('clspckr-opt-active');
	$(this).addClass('clspckr-opt-active');
	
	// Now Get the Variables
	var fld = $(this).attr('classpicker-field');
	var typ = $(this).attr('classpicker-type');
	var pre = $(this).attr('classpicker-preview');
	var cur = $('#'+fld).val();
	var set = cur.split(' ');
	
	// Set the Working Field	
	$('#clspckr-fld').attr({
		'classpicker-field':fld,
		'classpicker-type':typ,
		'classpicker-preview':pre,
		'class':cur,
		});
	
	// Refresh the Preview
	$('#'+pre).attr('class', $('#'+pre).attr('base-class')+' '+cur);
	
	// Remove the disabled overlay
	$('#clspckr-dis').fadeOut(250);
	
	// Reset on colour pickers
	$('.clspckr-clr').removeClass('clspckr-clr-active');
	
	var tys = typ;
	var tye = '';
	
	if(typ=='bghvr'){tys='bg';tye = '-hover';}
	if(typ=='txthvr'){tys='txt';tye = '-hover';}
	
	// Set the prefix for the row checks
	var rvl = tys+'-';
	
	// Loop through the colours and see if this one is active and add the class if true
	$('.clspckr-clr').each(function(i,e){
		if($.inArray(rvl + $(this).attr('classpicker-value') + tye, set) >= 0)
			{
			$(this).addClass('clspckr-clr-active');	
			}
		});
	});


$('body').on('click', '.clspckr-clr', function(){
	
	// Class clear and setting for this option
	$('.clspckr-clr').not($(this)).removeClass('clspckr-clr-active');
	
	// Get the values from our selected option and working field
	var nvl = $(this).attr('classpicker-value');
	var fld = $('#clspckr-fld').attr('classpicker-field');
	var typ = $('#clspckr-fld').attr('classpicker-type');
	var pre = $('#clspckr-fld').attr('classpicker-preview');
	
	var tys = typ;
	var tye = '';
	
	if(typ=='bghvr'){tys='bg';tye = '-hover';}
	if(typ=='txthvr'){tys='txt';tye = '-hover';}
	
	// Set the prefix for the row checks
	var rvl = tys+'-';
	
	var cls = rvl + nvl + tye;
	
	if($('#clspckr-fld').hasClass(cls))
		{
		// Now add the new class back into the worker
		$('#clspckr-fld').removeClass(cls);	
		$(this).removeClass('clspckr-clr-active');			
		}
	else
		{
		// Go through each colour for the type and remove it from the worker
		$('.clspckr-clr').each(function(i,e){
			$('#clspckr-fld').removeClass(rvl + $(this).attr('classpicker-value') + tye);
			});
			
		// Now add the new class back into the worker
		$('#clspckr-fld').addClass(cls);	
		$(this).addClass('clspckr-clr-active');	
		}
	
	// Update the working field with the new set
	var upd = $('#clspckr-fld').attr('class');
	
	// Update the actual field and preview
	$('#'+fld).val(upd);
	$('#'+pre).attr('class', $('#'+pre).attr('base-class')+' '+upd);
	});


/**
 *
 *	Classpicker - Widths
 *
 */

$('body').on('click', '.clswidth-opt', function(){
	
	// Toggle Classes on Field Selectos
	$('.clswidth-opt').not($(this)).removeClass('clswidth-opt-active');
	$(this).addClass('clswidth-opt-active');
	
	// Now Get the Variables
	var fld = $(this).attr('classpicker-field');
	var typ = $(this).attr('classpicker-type');
	var pre = $(this).attr('classpicker-preview');
	var cur = $('#'+fld).val();
	var set = cur.split(' ');
	
	// Set the Working Field	
	$('#clswidth-fld').attr({
		'classpicker-field':fld,
		'classpicker-type':typ,
		'classpicker-preview':pre,
		'class':cur,
		});
	
	$('#'+pre).attr('class', $('#'+pre).attr('base-class')+' '+cur);
	
	// Remove the disabled overlay
	$('#clswidth-dis').fadeOut(250);
	
	// Reset on colour pickers
	$('.clswidth-clr').removeClass('clswidth-clr-active');
	
	// Set the preset for the row val check
	var rvl = typ+'-';
	
	// Loop through the colours and see if this one is active and add the class if true
	$('.clswidth-clr').each(function(i,e){
		if($.inArray(rvl + $(this).attr('classpicker-value'), set) >= 0)
			{
			$(this).addClass('clswidth-clr-active');	
			}
		});
	});

$('body').on('click', '.clswidth-clr', function(){
	// Class clear and setting for this option
	$('.clswidth-clr').not($(this)).removeClass('clswidth-clr-active');
	$(this).addClass('clswidth-clr-active');
	
	// Get the values from our selected option and working field
	var nvl = $(this).attr('classpicker-value');
	var fld = $('#clswidth-fld').attr('classpicker-field');
	var typ = $('#clswidth-fld').attr('classpicker-type');
	var pre = $('#clswidth-fld').attr('classpicker-preview');
	
	// Set the prefix for the row checks
	var rvl = typ+'-';
	
	// Go through each colour for the type and remove it from the worker
	$('.clswidth-clr').each(function(i,e){
		$('#clswidth-fld').removeClass(rvl + $(this).attr('classpicker-value'));
		});
		
	// Now add the new class back into the worker
	if($('#clswidth-fld').hasClass(rvl+nvl))
		{
		// Now add the new class back into the worker
		$('#clswidth-fld').removeClass(rvl+nvl);	
		$(this).removeClass('clswidth-clr-active');			
		}
	else
		{
		// Go through each colour for the type and remove it from the worker
		$('.clswidth-clr').each(function(i,e){
			$('#clswidth-fld').removeClass(rvl + $(this).attr('classpicker-value'));
			});
			
		// Now add the new class back into the worker
		$('#clswidth-fld').addClass(rvl+nvl);	
		$(this).addClass('clswidth-clr-active');	
		}
	
	// Update the working field with the new set
	var upd = $('#clswidth-fld').attr('class');
	
	// Update the actual field
	$('#'+fld).val(upd);
	$('#'+pre).attr('class', $('#'+pre).attr('base-class')+' '+upd);
	});


