<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Shake extends CI_Model {

// User Settings
var $user 		= array();
var $pass 		= ''; // Password (md5)
var $pasc 		= ''; // Confirm (md5)
var $pase 		= ''; // Encrypted (After running $this->encode())
var $pasr 		= ''; // Raw password (For generating and emailing)

// Encryption Setting
var $session	= array();
var $name 		= '';
var $salt 		= '';
var $pepper 	= '';
var $chilli 	= '';

var $raw		= '';
var $enc		= '';
var $dec		= '';




public function __construct()
	{
	parent::__construct();
	
	$this->load->config('shake');
	
	$this->salt 	= $this->config->item('salt');
	$this->pepper 	= $this->config->item('pepper');
	$this->chilli 	= $this->config->item('chilli');
	$this->encrypt 	= $this->config->item('encrypt');
	$this->driver 	= $this->config->item('driver');
	$this->cipher 	= $this->config->item('cipher');
	$this->mode 	= $this->config->item('mode');
	$this->keycode	= $this->config->item('key');
	
	$this->name = md5('smews_website_'.$this->salt);
	}

/**
 *	Login
 */ 
public function login()
	{
	$this->admin->required(array(	'user' => 'You must input your username.',
									'pass' => 'You must input a password.'
									));
	
	$this->admin->validate();
	
	if(!isset($this->admin->response['error']))
		{
		$this->pass = $this->admin->postdata['pass'];
		$this->encode();
		
		$q = $this->db->where(array('useractive' => 1, 'username' => $this->admin->postdata['user'], 'userpassword' => $this->pase))->get('users');
		
		if($q->num_rows()==1)
			{
			$p = $q->row_array();
			
			$profile = array('usid' => $p['usid'], 'name' => $p['username'], 'email' => $p['useremail']);	
			
			$this->set($profile);
			
			$this->admin->success('Login successful.');
			}
		else
			{
			$this->admin->error('There was no user found matching those details. Please check your account info and try logging in again.');	
			}
		}
	
	$this->admin->respond();
	}

/**
 *	New User Password Generator
 */ 
public function generate()
	{
	$this->pasr = substr(sha1(date('Y-m-d-h:i:s').uniqid()),rand(4,8),8);
	
	$this->pass = md5($this->pasr);
	
	$this->encode();
	
	$this->admin->postdata['userpassword'] = $this->pase;
	}

/**
 *	Encode Login Password
 */ 
public function encode($pass=NULL)
	{
	$this->pass = $pass!=NULL ? $pass : $this->pass;		
	
	$this->pase = sha1($this->chilli.$this->pass);
	}

/**
 *	Compare and Set Password for Saving in User Profile
 */ 
public function password()
	{	
	$this->pass = isset($this->admin->postdata['userpassword']) 	? $this->admin->postdata['userpassword'] 	: '';
	$this->pasc = isset($this->admin->postdata['userpasswordc']) 	? $this->admin->postdata['userpasswordc'] 	: '';
	
	unset($this->admin->postdata['userpassword'], $this->admin->postdata['userpasswordc']);
	
	if($this->pass!='' && $this->pasc!='' && $this->pass!=$this->pasc)
		{
		$this->admin->error('Sorry but the passwords do not match. Double check they are they same.');
		}
		
	if($this->pass!='')
		{
		$this->encode();
		$this->admin->postdata['userpassword'] = $this->pase;
		}
	}


/**
 *	Setting User Sessions
 */ 
public function set($profile)
	{
	$this->name = md5('smews_website_'.$this->salt);
		
	$this->user = array(	'id' 	=> $profile['usid'],
							'name' 	=> $profile['name'],
							'email' => $profile['email'],
							);
	
	$_SESSION[$this->name] = $this->user;
	}


/**
 *	Validating Logins
 */ 
public function validate()
	{
	if($this->uri->uri_string()=='' || $this->uri->uri_string()=='login' || $this->uri->uri_string()== 'logout')
		{
		$this->user = array('id' => '', 'name' => '', 'email' => '');	
		}
	else
		{
		$this->load();
		}
	
	$this->alert();
	}


/**
 *	Load the User
 */ 
public function load()
	{
	$this->admin->site();
	
	$this->name = md5('smews_website_'.$this->salt);
	
	$this->user = isset($_SESSION[$this->name]) ? $_SESSION[$this->name] : array();
	
	if($this->uri->uri_string!='admin/login' && $this->uri->uri_string!='admin/logout' && $this->uri->uri_string!='ajax/online/login')
		{
		if(empty($this->user) || $this->user['id']=='' || $this->user['name']=='' || $this->user['email']=='')
			{
			$this->alert(array('error' => 'You must be logged in to view that page.'));
			header('Location: /admin/login');
			die('Not logged in!');
			}
		}
	}


/**
 *	Alert Prepare
 */

public function alert($set=array())
	{
	if(empty($set) && isset($_SESSION[$this->name.'_alert']))
		{
		$this->admin->alerts[] = $_SESSION[$this->name.'_alert'];
		$this->admin->message = $_SESSION[$this->name.'_alert'];
		unset($_SESSION[$this->name.'_alert']);
		}
		
	if(!empty($set))
		{
		$_SESSION[$this->name.'_alert'] = $set;
		}
	}

public function alerts()
	{
	if(empty($set) && isset($_SESSION[$this->name.'_alert']))
		{
		$this->admin->alerts[] = $_SESSION[$this->name.'_alert'];
		$this->admin->message = $_SESSION[$this->name.'_alert'];
		unset($_SESSION[$this->name.'_alert']);
		}
	}

}