<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Search extends CI_Model {

var $template		= 'search/listing';
var $pageuri		= 5;
var $data	 		= '';

// Search Core
var $table	 		= '';
var $index	 		= '';
var $portal			= 'admin/';
var $base 			= '';
var $link 			= '';
var $user			= array();
var $session 		= '';
var $process 		= '';

// Search Field and Columns
var $lookfor 		= '';
var $lookin 		= '';
var $coalesce		= array();
var $searchopts 	= array();


// Select and Joins
var $select	 		= '';
var $selectraw 		= '';

var $joins 			= array();
var $outerjoin 		= '';
var $outerjoins 	= array();
var $customjoins	= array();
var $alias			= '';


// Filter
var $groupby 		= '';


// Filter
var $filter 		= '';
var $filterby 		= '';
var $filterlbl 		= '';
var $filters 		= array();
var $fixedfilters 	= array();

// Ordering
var $orderby	 	= '';
var $ordering	 	= '';

// Limits
var $limits			= array(5, 10, 15, 25, 50);
var $limit			= '10';
var $pagenum		= '0';
var $offset			= '0';

// Empty Lists
var $no_results 	= 'Sorry but no results could be found matching your search. Try another search.';
var $no_records 	= 'The table does not contain any records yet.';

// List and Result
var $query			= '';
var $options		= array();
var $columns		= array();
var $result			= array();
var $total			= '';
var $paging			= array();



public function __construct()
	{
	parent::__construct();
	
	$this->admin->js('search.inc.js');
	}

public function run()
	{
	$this->orderby = isset($this->admin->postdata['orderby']) ? $this->admin->postdata['orderby'] : $this->orderby;
	$this->ordering = isset($this->admin->postdata['ordering']) ? $this->admin->postdata['ordering'] : $this->ordering;
	
	if($this->admin->view=='search/gallery')
		{
		$this->limits = array(6, 9, 12, 15, 30, 45);	
		$this->limit = 12;	
		}
	//$this->admin->views = array('search/header', 'search/listing', 'search/paging');	 // search/listing | search/gallery
	
	// Check for Post
	$this->data = $this->input->post();
	
	// If post is set then define and store in the session
	if(!empty($this->data))
		{
		foreach($this->data as $f => $v)
			{
			$this->$f = $v;	
			}
		
		$_SESSION['smews_search'.$this->session] = $this->data;
		}
	// If no post, check for a session
	elseif(isset($_SESSION['smews_search'.$this->session]))
		{
		foreach($_SESSION['smews_search'.$this->session] as $f => $v)
			{
			$this->$f = $v;	
			}	
		}
	// Otherwise it will use the defaults
	
	// Now define the offset
	$this->pagenum 	= $this->uri->segment($this->pageuri, 1);
	$this->offset 	= $this->pagenum > 1 ? ($this->pagenum - 1) * $this->limit : 0;
	
	// Start the query cache
	$this->db->start_cache();
	
	// Build the Query
	if($this->select!='')
		{
		if(!empty($this->coalesce))
			{
			foreach($this->coalesce as $name => $cols)
				{
				$this->select .= ', coalesce('.$this->db->dbprefix.implode(', ', $cols).') AS '.$name;			
				}
			
			$this->db->select($this->select, FALSE);
			}
		else
			{
			$this->db->select($this->select);	
			}
		}
	
	if($this->selectraw!='')
		{
		if(!empty($this->coalesce))
			{
			foreach($this->coalesce as $name => $cols)
				{
				$this->selectraw .= ', coalesce('.$this->db->dbprefix.implode(', ', $cols).') AS '.$name;			
				}
			}
		$this->db->select($this->selectraw, FALSE);	
		}
	
	if(!empty($this->joins))
		{
		foreach($this->joins as $tbl => $join)
			{
			if(is_array($join))
				{
				$par = $this->alias!='' ? $this->alias : $tbl;
				
				if(isset($join[2]))
					{
					$this->db->join($par, $tbl.'.'.$join[0].' = '.$join[2].'.'.$join[1], 'left');	
					}
				else
					{
					$this->db->join($par, $tbl.'.'.$join[0].' = '.$this->table.'.'.$join[1], 'left');	
					}
				}
			else
				{
				$par = $this->alias!='' ? $this->alias : $tbl;
				
				$this->db->join($par, $tbl.'.'.$join.' = '.$this->table.'.'.$join, 'left');	
				}
			}
		}
	
	if(!empty($this->outerjoins))
		{
		foreach($this->outerjoins as $tbl => $join)
			{
			$this->db->join($tbl, $tbl.'.'.$join.' = '.$this->table.'.'.$join, 'full');	
			}
		}
	/*
	if(!empty($this->customjoins))
		{
		foreach($this->customjoins as $tbl => $join)
			{
			$this->db->join($tbl, $tbl.'.'.$join[0].' = '.$this->table.'.'.$join[0], 'full');	
			}
		}*/
		
	if($this->lookfor!='')
		{
		if(!empty($this->coalesce) && isset($this->coalesce[$this->lookin]))
			{
			$s = 0;
			foreach($this->coalesce[$this->lookin] as $f)
				{
				if($s==1)
					{
					$this->db->or_like($f, $this->lookfor);	
					}
				else
					{
					$this->db->like($f, $this->lookfor);
					$s = 1;	
					}
				}
			}
		else
			{
			$this->db->like($this->lookin, $this->lookfor);	
			}
		}
	
	if($this->filter!='')
		{
		$this->db->where($this->filterby, $this->filter);	
		}
	
	if(!empty($this->fixedfilters))
		{
		$this->db->where($this->fixedfilters);	
		}
	
	if($this->groupby!='')
		{
		$this->db->group_by($this->groupby);	
		}
	
	// Stop the cache
	$this->db->stop_cache();
	
	// Run the count query first
	$this->total = $this->db->get($this->table)->num_rows();
	
	// Add the limit and offset
	if($this->offset > 0)
		{
		$this->db->limit($this->limit, $this->offset);	
		}
	else
		{
		$this->db->limit($this->limit);	
		}
	
	$this->db->order_by($this->orderby, $this->ordering);
	
	// Now run the final query
	$this->result = $this->db->get($this->table)->result_array();
	
	//echo '<pre>';die(print_r($this->result));
	
	// Set the Paging
	$this->load->library('pagination');
	
	$this->paging['base_url'] 			= '/'.$this->admin->base.$this->base.'/page/';
    $this->paging['total_rows'] 		= $this->total;
    $this->paging['per_page'] 			= $this->limit;
	$this->paging['uri_segment'] 		= $this->pageuri;
	$this->paging['use_page_numbers'] 	= TRUE;
	$this->paging['page_query_string'] 	= FALSE;
	
	$this->paging['cur_tag_open'] 		= '<span>';
	$this->paging['cur_tag_close']		= '</span>';
	
	$this->pagination->initialize($this->paging);
	
	$this->base = $this->portal.$this->base;	
	}

public function column($field, $label, $width, $type, $empty=NULL, $options=array())
	{
	$this->columns[$field] = array('label' => $label, 'width' => $width, 'type' => $type, 'empty' => $empty);
	
	if(!empty($options))
		{
		foreach($options as $f => $v)
			{
			$this->columns[$field][$f] = $v;	
			}
		}
	}

public function inline()
	{
	$head = $this->load->view('../_admin/views/search/header', array(), true);
	$list = $this->load->view('../_admin/views/'.$this->admin->view, array(), true);
	$foot = $this->load->view('../_admin/views/search/paging', array(), true);
	
	return array('head' => $head, 'list' => $list, 'foot' => $foot);
	}

}