<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Media extends CI_Model {

// Media Upload Variables
var $path		= '/_media/';
var $fullpath	= '';
var $folder 	= 'images';
var $fieldname 	= 'fileupload';
var $filename	= '';
var $fileinfo	= array();
var $postdata 	= array();
var $response 	= array();
var $settings 	= array();
var $setname	= '';
var $randomname	= TRUE;
var $overwrite	= FALSE;
var $maketn		= '0';

// Media Resizing Variables
var $resize		= '';
var $resizing	= array();
var $resizeerr	= '';

// Media Cropping Variables
var $crop	= array();

// Media Removal Variables
var $remove		= '';
var $removal	= array();

// Media Manager / Listing Variables
var $paths		= array();
var $files		= array();
var $ignores	= array('.htaccess', '_notes/', 'index.php', 'index.html', 'tn/');



public function __construct()
	{
	parent::__construct();
	}

// Upload Settings
public function settings()
	{
	$this->fullpath						= $_SERVER['DOCUMENT_ROOT'].$this->path;
	$this->settings['upload_path'] 		= $this->fullpath.$this->folder.'/';
	$this->settings['allowed_types'] 	= !isset($this->settings['allowed_types']) || $this->settings['allowed_types']=='' ? '*' : $this->settings['allowed_types'];
	$this->settings['encrypt_name'] 	= $this->randomname;
	$this->settings['overwrite'] 		= $this->overwrite;
	$this->settings['file_ext_tolower'] = TRUE;
	
	if($this->setname!='')
		{
		$this->settings['file_name'] = $this->setname;	
		}
	}


// Media Manager Upload
public function uploader()
	{
	$this->admin->required = array(	'directory' => 'The file directory is missing.',
									);
									
	$this->admin->validate();

	if(!isset($this->admin->response['error']))
		{
		$this->maketn = 1;
		
		$this->folder = $this->admin->postdata['directory'];
		
		$this->upload();
		
		if(!isset($this->admin->response['error']))
			{
			$imgs = array('.jpg', '.png', 'jpeg', '.gif');
			
			$le = substr($this->filename, -4);
			
			if(in_array($le, $imgs))
				{
				$t = 'media-file-image';
				$d = getimagesize('./_media/'.$this->folder.'/'.$this->filename);
				$i = '<span class="media-file-info"><span class="media-file-lbl">Dimensions:</span> '.$this->fileinfo['image_width'].'w x '.$this->fileinfo['image_height'].'h</span>';
				$i .= '<span class="media-file-info"><span class="media-file-lbl">Type:</span> '.$this->fileinfo['file_type'].'</span>';
				$i .= '<span class="media-file-tools" media-path="'.$this->folder.'" media-img="'.$this->filename.'">';
				$i .= '<span class="media-file-tool" media-action="crop"><i class="fa fa-crop fa-icn-sml fa-icn-sml-30"></i>Crop</span>';
				$i .= '<span class="media-file-tool" media-action="resize"><i class="fa fa-expand fa-icn-sml fa-icn-sml-30"></i>Resize</span>';
				$i .= '<span class="media-file-tool" media-action="delete"><i class="fa fa-trash fa-icn-sml fa-icn-sml-30"></i>Delete</span>';
				$i .= '</span>';
				$f = '<img src="/_media/'.$this->folder.'/'.$this->filename.'" alt="'.$this->filename.'" title="'.$this->filename.'" class="media-img" />';	
				}
			elseif(substr($file, -4)=='.pdf')
				{
				$t = 'media-file-pdf';
				$i = '<span class="media-file-tools" media-path="'.$this->folder.'" media-img="'.$this->filename.'">';
				$i .= '<span class="media-file-tool" media-action="delete"><i class="fa fa-trash fa-icn-sml fa-icn-sml-30"></i>Delete</span>';
				$i .= '</span>';
				$f = '<a href="/_media/'.$this->folder.'/'.$this->filename.'" class="media-file-link" target="_blank"><i class="fa fa-pdf-o fa-icn-lrg fa-icn-lrg-60"></i>View PDF '.$this->filename.'</a>';	
				}
			else
				{
				$t = 'media-file-dl';
				$i = '<span class="media-file-tools" media-path="'.$this->folder.'" media-img="'.$this->filename.'">';
				$i .= '<span class="media-file-tool" media-action="delete"><i class="fa fa-trash fa-icn-sml fa-icn-sml-30"></i>Delete</span>';
				$i .= '</span>';
				$f = '<a href="/_media/'.$this->folder.'/'.$this->filename.'" class="media-file-link"><i class="fa fa-download fa-icn-lrg fa-icn-lrg-60"></i>Download '.$this->filename.'</a>';	
				}				
			
			$o = '<div class="media-file media-file-sm '.$t.'">'.$f.$i.'</div>';
			
			$this->admin->success('The file has been uploaded.');
			
			$this->admin->response(array(	'newfile' => $o,
											'folder' => $this->folder,
											));	
			}
		}
	
	$this->admin->respond();
	}


// Upload Script	
public function upload()
	{
	$this->settings();
	
	$this->load->library('upload', $this->settings);
	
	if($this->upload->do_upload($this->fieldname))
		{
		$this->fileinfo = $this->upload->data();
		
		$this->filename = $this->fileinfo['file_name'];
		
		$this->thumbnail();
		}
	else
		{
		$this->admin->error('There was an error uploading the file.<br />'.$this->upload->display_errors());	
		}
	}


// Media Manager Deleting
public function delete()
	{
	$this->admin->required = array(	'folder' => 'The file directory is missing.',
									'file' => 'The file name is missing.',
									);
									
	$this->admin->validate();

	if(!isset($this->admin->response['error']))
		{
		$this->folder = $this->admin->postdata['folder'];
		$this->remove($this->admin->postdata['file']);
		
		if(isset($this->removal['success']))
			{
			$this->admin->success($this->removal['success']);	
			}
		elseif(isset($this->removal['missing']))
			{
			$this->admin->error($this->removal['missing']);	
			}
		elseif(isset($this->removal['error']))
			{
			$this->admin->error($this->removal['error']);	
			}
		}
	
	$this->admin->respond();	
	}

// Removal Script
public function remove($file=NULL)
	{
	$this->fullpath = $_SERVER['DOCUMENT_ROOT'].$this->path;
	
	if($file==NULL)
		{
		$this->removal['missing'] = 'Sorry but the name is empty.';	
		}
	elseif(!file_exists($this->fullpath.$this->folder.'/'.$file))
		{
		$this->removal['missing'] = 'The file does not exist. Check file path: '.$this->path.$this->folder.'/'.$file;	
		}
	else
		{
		if(unlink($this->fullpath.$this->folder.'/'.$file))
			{
			if(file_exists($this->fullpath.$this->folder.'/tn/'.$file))
				{
				unlink($this->fullpath.$this->folder.'/tn/'.$file);	
				}
				
			$this->removal['success'] = 'Your file has been removed.';
			}
		else
			{
			$this->removal['error'] = 'Sorry but there was an error removing the file.';
			}
		}
	}


// Thumbnail Generation
public function thumbnail()
	{
	if($this->maketn!='0' && $this->fileinfo['is_image']=='1')
		{
		$this->resizing['image_library'] 	= 'gd2';
		
		$this->resizing['source_image'] 	= '.'.$this->path.$this->folder.'/'.$this->filename;
		$this->resizing['new_image'] 		= '.'.$this->path.$this->folder.'/tn/'.$this->filename;
		
		$this->resizing['maintain_ratio'] 	= TRUE;
		$this->resizing['width']         	= 250;
		$this->resizing['height']       	= 250;
		
		$this->load->library('image_lib', $this->resizing);
		
		if($this->image_lib->resize())
			{
			$this->fileinfo['thumbnail'] = '1';	
			}
		else
			{
			$this->fileinfo['thumbnail'] = '0';
			
			if(isset($this->image_lib->error_msg) && !empty($this->image_lib->error_msg))
				{
				foreach($this->image_lib->error_msg as $msg)
					{
					$this->resizeerr .= $msg.'<br />';	
					}
				}
			
			$this->admin->response('img_lib', $this->resizeerr);
			}
		}
	
	}



// Media Manager Cropping
public function crop()
	{
	$this->admin->required = array(	'editfile' => 'The file name is missing.',
									'directory' => 'The file directory is missing.',
									'xc' => 'The starting X coordinate is missing or invalid.',
									'yc' => 'The starting Y coordinate is missing or invalid.',
									'wc' => 'The width is invalid.',
									'hc' => 'The height is invalid.',
									);
									
	$this->admin->validate();

	if(!isset($this->admin->response['error']))
		{
		$this->folder = $this->admin->postdata['directory'];
		$this->filename = $this->admin->postdata['editfile'];
		
		$this->crop();	
		}
	
	$this->admin->respond();
	}

// Crop Script
public function cropper()
	{
	$this->crop['source_image'] 	= '.'.$this->path.$this->folder.'/'.$this->filename;
	$this->crop['maintain_ratio'] 	= false;
	
	$this->crop['width'] 			= $this->admin->postdata['wc'];
	$this->crop['height'] 			= $this->admin->postdata['hc'];
	$this->crop['x_axis'] 			= $this->admin->postdata['xc'];
	$this->crop['y_axis'] 			= $this->admin->postdata['yc'];
	
	$this->load->library('image_lib');
	
	$this->image_lib->initialize($this->crop); 
	
	if(!$this->image_lib->crop())
		{
		$this->admin->error($this->image_lib->display_errors());	
		}
	else
		{
		if($this->crop['width'] > 250 && $this->crop['width'] > 250)
			{
			$this->thumbnail();
			
			$this->admin->success('Image cropped and thumbnail generated.');
			}
		else
			{
			unlink($_SERVER['DOCUMENT_ROOT'].'/'.$this->path.$this->folder.'/tn/'.$this->filename);
			
			$this->admin->success('Image cropped but smaller than thumbnails size so no thumb created.');	
			}
		}
	}


// File Mapping
public function map()
	{
	$this->load->helper('directory');
	
	$this->paths();
	
	$this->files();	
	}

// Directories
public function paths()
	{
	$paths = directory_map('./_media/', 1);
	
	foreach($paths as $path)
		{
		if(!in_array($path, $this->ignores))
			{
			$this->paths[$path] = $path;	
			}
		}
	}

// Files
public function files()
	{
	foreach($this->paths as $path)
		{
		$files = directory_map('./_media/'.$path.'/');
		
		foreach($files as $file)
			{
			if(!in_array($file, $this->ignores) && !is_array($file))
				{
				$this->files[$path][] = $file;	
				}
			}
		}
	}


}