<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Articles extends CI_Model {

// Variables
var $coid 		= '';
var $value		= '';

// Listing and Editing URLs
var $name		= 'Article';
var $base 		= 'article/listing/';
var $link 		= 'article/edit/';

// Edit Folder Name
var $editor 	= 'article/edit';

// Table Settings
var $table 		= 'content';
var $index 		= 'coid';

var $select		= '';

var $join		= array();

var $filterby 	= 'contentactive';
var $filterlbl 	= 'Status';
var $filters	= array('1' => 'Active', '2' => 'Inactive');

var $orderby 	= 'contentrealorder';
var $ordering 	= 'asc';

var $options	= array('contenttitle' => 'Title');

public function __construct()
	{
	parent::__construct();
	}

public function id()
	{
	$this->value = $this->uri->segment(4) ? $this->uri->segment(4) : $this->value;
	
	$this->value = isset($this->admin->postdata['index']) && $this->admin->postdata['index']!='' ? $this->admin->postdata['index'] : $this->value;	
	}

public function search()
	{
	$this->admin->model('search');
	
	// Page View and Title
	$this->admin->view 	= 'search/listing'; // search/listing | search/gallery
	$this->admin->title = $this->name.' Listing';
	
	// Set Common Settings
	$this->search->table		= $this->table;
	$this->search->index 		= $this->index;
	$this->search->session 		= $this->table;
	$this->search->base 		= $this->base;
	$this->search->link 		= $this->link;
	
	$this->search->process		= strtolower($this->name);
	
	$this->search->select 		= $this->select;
	$this->search->joins 		= $this->join;
	
	$this->search->options 		= $this->options;
	
	$this->search->filterby 	= $this->filterby;
	$this->search->filterlbl 	= $this->filterlbl;
	$this->search->filters 		= $this->filters;
	
	$this->search->orderby 		= $this->orderby;
	$this->search->ordering 	= $this->ordering;
	
	$this->search->no_results = 'Sorry but no web pages matched your search. Please try searching again or search by a different field.';
	$this->search->no_records = 'No web pages have been setup in the system yet.';
	
	$this->search->column('contentactive', 'Active', '10', 'switcher');
	$this->search->column('contentrealorder', 'Order', '10', 'ordering', '', array('display' => 'contentorder'));
	$this->search->column('contenttitle', 'Title', '80', 'text');
	
	// Run the Search
	$this->search->run();
	
	if($this->admin->inline==1)
		{
		$views = $this->search->inline();
		
		$this->admin->response = array('success' => 'Search processed.', 'head' => $views['head'], 'list' => $views['list'], 'foot' => $views['foot']);
		
		$this->output->set_content_type('application/json')->set_output(json_encode($this->admin->response));
		}
	}

public function get()
	{
	// Set the ID
	$this->id();
	
	// Get the Record
	$this->admin->record 	= $this->db->where($this->index, $this->value)->get('content')->row_array();
	
	// Set Page View and Title
	$this->admin->view 		= $this->editor;
	$this->admin->title 	= $this->name.' Editor';
	}

public function save()
	{
	$this->id();
	
	$this->admin->required(array(	'pagetype' 				=> 'You must select a page type.',
									'contenttitle' 			=> 'You must give the page a title.',
									'contentkeywords' 		=> 'You must set the meta keywords for the page. This is used for SEO.',
									'contentdescription' 	=> 'You must set the meta description for the page. This is used for SEO',
									));
	
	$this->admin->validate();
	
	if(!isset($this->admin->response['error']))
		{	
		if($this->value!='')
			{
			$this->admin->response 	= $this->db->update('content', $this->admin->postdata, array($this->index => $this->value)) 
									? array('success' => 'The content item has been updated.') 
									: array('error' => 'Sorry but there was an error updating the content item.');
			}
		else
			{
			$this->admin->response 	= $this->db->insert('content', $this->admin->postdata) 
									? array('success' => 'The content item has been created.', 'newid' => $this->db->insert_id()) 
									: array('error' => 'Sorry but there was an error creating the content item.');	
			}
		}
	
	$this->output->set_content_type('application/json')->set_output(json_encode($this->admin->response));	
	}

public function delete()
	{
	
	}

}