<?php

function niceToggle($fieldname, $optalbl, $optaval, $optblbl, $optbval, $value, $fieldid)
	{
	if($value==$optbval)
		{
		$lbl = $optblbl;
		$rwcls = ' twoWayToggleOff';
		$rlcls = ' twoWayToggleSwitched';
		}
	else
		{
		$lbl = $optalbl;
		$rwcls = '';
		$rlcls = '';	
		}
	
	echo '<span class="niceToggleWrapper"><input type="text" class="niceHiddenToggle niceHiddenField" id="'.$fieldid.'" name="'.$fieldname.'" value="'.$value.'" /><span class="twoWayToggle'.$rwcls.'" data-rel="'.$fieldid.'" data-opta="'.$optalbl.'" data-optb="'.$optblbl.'" data-vala="'.$optaval.'" data-valb="'.$optbval.'"><span class="twoWayToggleLbl'.$rlcls.'">'.$lbl.'</span></span></span>';
	}
	
function niceRadio($fieldname, $fieldid, $options, $value, $class=NULL)
	{
	$id = $fieldid!='' ? $fieldid : $fieldname;
	$class = $class!='' ? ' '.$class : '';
	// First we output the wrapper and the hidden field
	echo '<span class="niceRadioSet'.$class.'"><input type="text" name="'.$fieldname.'" id="'.$id.'" value="'.$value.'" class="hiddenRadioField" />';
	
	// Then for each option, we output the radio selector
	foreach($options as $key => $label)
		{
		$sel = $value==$key ? '<span class="radioOptionSelected"></span>' : '';
		echo '<span class="radioOption" opt-val="'.$key.'" opt-fld="'.$id.'"><span class="radioOptionBox">'.$sel.'</span><span class="radioOptionLbl">'.$label.'</span></span>';
		}

	// Then we close the wrapper for the group
    echo '</span>';
	}

function niceCheckbox($fieldname, $value, $label, $current, $tabindex=NULL)
	{
	if($current==$value)
		{
		$chkd = ' checked="checked"';
		$icn = ' niceCheckboxSelected';
		$wrp = '  is-chkd="y"';
		}
	else
		{
		$chkd = '';
		$icn = '';
		$wrp = '  is-chkd="n"';
		}
	
	$tab = $tabindex!=NULL ? ' tabindex="'.$tabindex.'"' : '';
	
	echo '<span class="niceCheckbox"'.$wrp.'><input class="niceCheckboxField" type="checkbox" value="'.$value.'" name="'.$fieldname.'" id="'.$fieldname.'"'.$chkd.'><span class="niceCheckboxIcon'.$icn.'"'.$tab.'></span><span class="niceCheckboxLbl">'.$label.'</span></span>';
	}

function niceSelect($fieldname, $options, $value, $listclass, $listid, $blankrow, $tabindex=NULL)
	{
	
	$first = array();
	foreach($options as $k => $v)
		{
		if(empty($first) || !isset($first['id'])  || !isset($first['label']))
			{
			$first['id'] = $k;
			$first['label'] = $v;
			}
		}
	
	$tab = $tabindex!=NULL ? ' tabindex="'.$tabindex.'"' : '';
	
	$value = $blankrow=='' && $value=='' && isset($first['id']) ? $first['id'] : $value;
	$label = isset($options[$value]) ? $options[$value] : '';
	
	echo '<span class="niceSelect '.$listclass.'">
		<input type="text" name="'.$fieldname.'" id="'.$listid.'" value="'.$value.'" class="niceSelectValue" my-val="'.$value.'" new-val="'.$value.'" new-lbl="'.$label.'" autocomplete="off"'.$tab.' />';
	
	if(isset($options[$value]))
		{
		echo '<span class="niceSelectCurrent">'.$options[$value].'<span class="niceSelectArrow fa fa-angle-down"></span></span>'; 
		}
	else
		{
		if($blankrow!='')
			{
			echo '<span class="niceSelectCurrent">[ '.$blankrow.' ]<span class="niceSelectArrow fa fa-angle-down"></span></span>'; 	
			}
		else
			{
			echo '<span class="niceSelectCurrent">'.$first['label'].'<span class="niceSelectArrow fa fa-angle-down"></span></span>';
			}
		}
	
	echo '<span class="selectOptionsList">';
	
	if($blankrow!='')
		{
		$c = $value=='' ? ' selectOptionCurrent' : '';
		echo '<span class="selectOptionListItem selectOptionListItemBlank'.$c.'" opt-val="" opt-lbl="[ '.$blankrow.' ]">[ '.$blankrow.' ]</span>';	
		}
	
	if(!empty($options))
		{
		foreach($options as $k => $v)
			{
			$c = $k==$value ? ' selectOptionCurrent' : '';
			echo '<span class="selectOptionListItem'.$c.'" opt-val="'.$k.'" opt-lbl="'.$v.'">'.$v.'</span>';	
			}
		}
	
	echo '</span></span>';
	
	}

function niceFileInput($fieldname, $fieldid, $fieldclass=NULL, $labelclass=NULL)
	{
	$fieldclass = $fieldclass!=NULL ? ' '.$fieldclass : '';
	$labelclass = $labelclass!=NULL ? ' '.$labelclass : '';
	echo '<span class="niceFileWrapper"><input type="file" name="'.$fieldname.'" id="'.$fieldid.'" class="niceFileInput'.$fieldclass.'" size="20" /><input type="text" class="formInput niceFileTitle'.$labelclass.'" readonly="readonly" id="filetitle" name="filetitle" placeholder="Please select your file" /><span class="niceFileBrowser">Browse</span><span class="niceFileProgress" id="'.$fieldid.'-progress"><span class="progress-bar progress-bar-success"></span></span></span>';	
	}