<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Online extends CI_Controller {

public function __construct()
	{
	parent::__construct();
	
	$this->load->model('admin');
	
	$this->admin->prepare();
	}

public function _remap()
	{
	if($this->uri->segment(2)=='logout')
		{
		$this->logout();
		}
	elseif($this->uri->segment(2)=='profiler')
		{
		$this->profiler();
		}
	elseif($this->uri->segment(2)=='settings' || $this->uri->segment(2)=='master')
		{
		$this->settings();
		}
	else
		{
		$this->index();
		}
	
	$this->admin->output();
	}

public function index()
	{
	$this->admin->title = 'Admin Portal Login';
	$this->admin->view = 'admin/login';
	
	$this->admin->js('login.inc.js');
	$this->admin->css('login.css');
	
	
	}

public function logout()
	{
	session_destroy();
	header('Location: /');
	die();
	}

// Edit Form	
public function settings()
	{
	// Page View and Title
	$this->admin->view = array(	'settings/head',
								'settings/website',
								'settings/contact',
								'settings/address',
								'settings/display',
								'settings/meta',
								'settings/webmaster',
								'settings/sitemap',
								'settings/social',
								'settings/closed',
								'settings/error',
								'settings/foot'
								);
								
	$this->admin->title = 'Website Settings';
	
	$this->admin->site();
	
	$this->admin->record = $this->admin->site;
	
	$this->admin->themes();
	
	// Define the Toolbar
	$this->admin->toolbar('save', 'Save Site Settings', 'fa-check', 'form', '', '');
	
	$this->admin->js('ajaxuploads/ajax.uploads.js');
	$this->admin->js('tinymce/tinymce.min.js');
	$this->admin->js('master.inc.js');
	}

public function profiler()
	{
	if($_SERVER['REMOTE_ADDR']=='203.206.137.6')
		{
		phpinfo();
		die();	
		}
	else
		{
		die('Forbidden');	
		}
	}

}